package topdown.concrete_operator;

import topdown.data_structures.*;
import topdown.operator.*;

import java.util.List;

public interface ConcreteOperator extends Operator {

    /*returns next tuple of the result relation*/
    public Tuple next();

    /*reverts iterator to initial state*/
    public void reset();

    /*returns true if every tuple returned by o1 is returned by o2 as well*/
    public static boolean isSubset(ConcreteOperator o1, ConcreteOperator o2) {
        Tuple tuple1 = o1.next();
        while (tuple1 != null) {
            o2.reset();
            Tuple tuple2 = o2.next();
            boolean found = false;
            while (tuple2 != null) {
                if ( tuple1.equals(tuple2) ) {
                    found = true;
                    break;
                }
                tuple2 = o2.next();
            }
            if ( !found ) return false;
            tuple1 = o1.next();
        }
        return true;
    }


}
